function sys_state = Attenuation_Closed_sys(t,xx, A, B, C, D1, D2, F, K, N_r, J_r, L_r, H_r)
X = xx(1:3);
Z = xx(4:7);

global Intr_ts Intr_count Intr_tmp
global Intr_hatf1 Intr_hatx1 Intr_hatx2 Intr_hatx3 Intr_f1 


f = 0.5 + 1 * sin(2.5*pi*t); % fault
da = 0.5 * cos(2.5*t) + cos(2*t)*0.2*sin(X(1))*cos(X(2)); % actuator attack
ds = cos(pi*t);  % sensor attack
d = [ds;da];

% controller
u = -K*X;

% observer
y = C*X + D2*d;
hat_x = Z + H_r*y;

hat_X = hat_x(1:3);
hat_f = hat_x(4);

dot_Z = N_r*Z + J_r*u + L_r*y;

% sys dynamic
dot_X = A*X + B*u + D1*d;

% % data saving 
if mod(Intr_tmp,2)==0
    Intr_count = Intr_count + 1;
Intr_ts(Intr_count) = t;
Intr_f1(Intr_count) = f;
Intr_hatf1(Intr_count) = f - hat_f;
Intr_hatx1(Intr_count) = X(1) - hat_X(1);
Intr_hatx2(Intr_count) = X(2) - hat_X(2);
Intr_hatx3(Intr_count) = X(3) - hat_X(3);
end
Intr_tmp = Intr_tmp + 1;

sys_state = [dot_X; dot_Z];